/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lane;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionLaneBus
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.lane.eui.EnumeratedResources";
    private static String laneBundle = "ibm.nways.lane.Resources";
    private boolean loggingOn = false;

    public ActionLaneBus() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionLaneBus");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        if (this.loggingOn) {
            System.out.println("BUS OperStaus = " + statusModelInfo.get("Panel.BusConfOperStatus") + n);
        }
        Integer n2 = (Integer)statusModelInfo.get("Panel.BusConfOperStatus");
        Integer n3 = (Integer)statusModelInfo.get("Panel.BusConfAdminStatus");
        int n4 = n2;
        int n5 = n3;
        StatusAndExplain statusAndExplain = this.evaluateBus(n4, n5, n);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBus - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(laneBundle, "STATUS_NAME_BUS", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBus - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(laneBundle, "STATUS_TABLE_BUS");
        return i18NString;
    }

    private StatusAndExplain evaluateBus(int n, int n2, int n3) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n3)};
        if (n2 == 2 && n == 2) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[0] = new I18NMsgFormat(laneBundle, "busstatus", objectArray2);
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.BusModel.Panel.BusConfOperStatus.up");
        } else if (n2 == 2 && n == 3) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[0] = new I18NMsgFormat(laneBundle, "busstatus", objectArray2);
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.BusModel.Panel.BusConfOperStatus.down");
        } else if (n2 == 3) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            objectArray[0] = new I18NMsgFormat(laneBundle, "busstatus", objectArray2);
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.lane.model.BusModel.Panel.BusConfOperStatus.down");
        } else {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray[0] = new I18NMsgFormat(laneBundle, "busstatus", objectArray2);
            objectArray[1] = new I18NString(enumBundle, "unknown");
        }
        statusAndExplain.explain = new I18NGiblets(laneBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionLaneBus.this = ActionLaneBus.this;
        }
    }
}

